/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VersionComparator;

public class OSVerCompatXMLEntry {
    private String m_osversion = null;
    private String m_matchtype = null;
    static final String MATCH_TYPE_EQUALS = "EQUALS";
    static final String MATCH_TYPE_GREATER = "GREATER";
    static final String OSVER_COMPARE_DELIM = ".";

    public OSVerCompatXMLEntry(String vers, String matchtype) {
        this.m_osversion = vers;
        this.m_matchtype = matchtype;
    }

    public void setVersion(String vers) {
        this.m_osversion = vers;
    }

    public void setMatchType(String matchtype) {
        this.m_matchtype = matchtype;
    }

    public String getVersion() {
        return this.m_osversion;
    }

    public String getMatchType() {
        return this.m_matchtype;
    }

    public int compareVersion(String reqdversion) {
        if (this.m_matchtype.equals(MATCH_TYPE_EQUALS)) {
            Trace.out((String)("Comparing strings " + reqdversion + " and " + this.m_osversion));
            VersionComparator versionComparator = new VersionComparator(OSVER_COMPARE_DELIM);
            return versionComparator.compare(this.m_osversion, reqdversion);
        }
        Trace.out((String)("OSVerCompatXMLEntry.compare(): Match type " + this.m_matchtype + " NOT supported"));
        return -1;
    }
}

